/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.transfer.fluid.item;

import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1805;
import net.minecraft.class_1935;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public class FluidBucketWrapper
implements SingleSlotStorage<FluidVariant> {
    @NotNull
    protected ContainerItemContext context;

    public FluidBucketWrapper(@NotNull ContainerItemContext context) {
        this.context = context;
    }

    public boolean canFillFluidType(FluidVariant resource, long amount) {
        if (resource.getFluid() == class_3612.field_15910 || resource.getFluid() == class_3612.field_15908) {
            return true;
        }
        return !new class_1799((class_1935)resource.getFluid().method_15774()).method_7960();
    }

    @NotNull
    public FluidStack getFluid() {
        class_1792 item = this.context.getItemVariant().getItem();
        if (item instanceof class_1755) {
            class_1755 bucketItem = (class_1755)item;
            return new FluidStack(bucketItem.field_7905, 81000L);
        }
        return FluidStack.EMPTY;
    }

    protected void setFluid(@NotNull FluidStack fluidStack) {
        try (Transaction tx = TransferUtil.getTransaction();){
            if (fluidStack.isEmpty()) {
                if (this.context.exchange(ItemVariant.of((class_1935)class_1802.field_8550), 1L, (TransactionContext)tx) == 1L) {
                    tx.commit();
                }
            } else if (this.context.exchange(ItemVariant.of((class_1799)this.getFilledBucket(fluidStack)), 1L, (TransactionContext)tx) == 1L) {
                tx.commit();
            }
        }
    }

    public boolean isResourceBlank() {
        return this.getResource().isBlank();
    }

    public FluidVariant getResource() {
        return this.getFluid().getType();
    }

    public long getAmount() {
        return this.getFluid().getAmount();
    }

    public long getCapacity() {
        return 81000L;
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        if (this.context.getAmount() != 1L || maxAmount < 81000L || this.context.getItemVariant().getItem() instanceof class_1805 || !new FluidStack(resource, maxAmount).isEmpty() || !this.canFillFluidType(resource, maxAmount)) {
            return 0L;
        }
        this.setFluid(new FluidStack(resource, maxAmount));
        return 81000L;
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        if (this.context.getAmount() != 1L || maxAmount < 81000L) {
            return 0L;
        }
        FluidStack fluidStack = this.getFluid();
        if (!fluidStack.isEmpty() && fluidStack.isFluidEqual(resource)) {
            this.setFluid(FluidStack.EMPTY);
            return fluidStack.getAmount();
        }
        return 0L;
    }

    @NotNull
    public class_1799 getFilledBucket(@NotNull FluidStack fluidStack) {
        class_3611 fluid = fluidStack.getFluid();
        if (!fluidStack.hasTag() || fluidStack.getTag().method_33133()) {
            if (fluid == class_3612.field_15910) {
                return new class_1799((class_1935)class_1802.field_8705);
            }
            if (fluid == class_3612.field_15908) {
                return new class_1799((class_1935)class_1802.field_8187);
            }
        }
        return new class_1799((class_1935)fluidStack.getFluid().method_15774());
    }
}

